/**********************************************************************************************
* Device      : AD18F08
* Author      : fengxuanmian
* Version     : V0.0.1
* Date        : 2023.5.4
* Description : 配置字中选择LVEN_ON即使能低电压复位,低电压复位阈值选择为2.4V
*               当VDD高于约2.4V时，IC正常工作，PB3每隔10ms会翻转一次  当VDD低于约2.4V时IC将产生复位 不再出现PB3翻转情况
*               也可配置禁止低电压复位，共有8档低电压复位阈值可配置，可见头文件
***********************************************************************************************/

#include "AD18F08.h"

/*********************************************************************************************
* 常用配置字功能说明：
*
* _FINTOSC_DIV1     :  内部时钟分频选择
* _DBG_OFF          :  禁用DEBUG模式（使能后DEBUG口不能做普通IO用）
* _LVREN_ON         :  使能LVR
* _LVR24V           :  选择LVR电压为2.4V
* _FLASH_CP1_OFF    :  1K~2K*16 FLASH保护位
* _FLASH_CP0_OFF    :  0~1K*16 FLASH保护位
* _IDIS_OFF	     	:  模拟IO打开，数据读取控制位
* _CKSUM_OFF        :  使能程序校验
* _CBP_OFF			:  代码保护选择位
* _RESETE_OFF       :  禁用外部复位
* _RSEL				:  端口上下拉电阻选择
* _STV_ON		    :  堆栈溢出复位使能位
* _PSUT_1		    :  上电复位时间选择位
* _FCPU_4T          :  选择指令周期为4T模式
* _WDTE_OFF         :  看门狗使能位
* _TWDT_000         :  看门狗溢出时间选择位
* _OSCM_HIRC_16M    :  选择内部高速时钟16MHz
* _ADCSP_ON			:  ADC采集速度选择位

*
* 注意：1.配置字若无特别需求请勿修改；
*       2.其他配置字及相应功能见Datasheet及头文件；
*
************************************************************************************************/

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_ON_1L     & _LVR24V_1L                                                  );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L    & _TWDT_100_3L                                                );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    &_ADCSP_ON_4L                                                                                      );

//---------配置字 LVREN 可选--------------
//_LVREN_ON_1L         使能LVR复位
//_LVREN_OFF_1L        禁止LVR复位
//------------------------
//---------配置字 LVR 可选--------------
//_LVR24V_1L                 LVR复位电压设置为2.4V
//_LVR27V_1L                 LVR复位电压设置为2.7V
//_LVR30V_1L                 LVR复位电压设置为3.0V
//_LVR33V_1L                 LVR复位电压设置为3.3V
//_LVR36V_1L                 LVR复位电压设置为3.6V
//_LVR38V_1L                 LVR复位电压设置为3.8V
//_LVR42V_1L                 LVR复位电压设置为4.2V
//_LVR43V_1L                 LVR复位电压设置为4.3V
//------------------------

void main(void)
{

	TRISB3=0;      //PB3设置为输出
    PB3  = 0;      //PB3设置初始值为0

    while(1)
    {
		__delay_ms(10);                //10ms延时后翻转PB3
		PB3=~PB3;
	}
}

//高优先级中断服务函数
void interrupt ISR_h (void)
{

}

//低优先级中断服务函数
void interrupt low_priority ISR_l (void)
{

}

